/*  Oct 2011 N9APK  n9apk@arrl.net    Clark Sell 

Ver 1.0  Oct 2011 
           Digital LCD clock with real time battery backup "DS1307" clock module.
           With 10 min countdown timer with CW ID and ID LED's  Triggered by rf detection or any IR remote key entry


Ver 1.1  Feb. 2012 Added SWR Display to the code. Testing but the Pickup unit in the 630 needs to be changed 
          to display the correct readings...  Code added but not  activate,  If you want to work
          on it It's on your own. The code works the SB-630 Hardware pickup need to be changed !!!
          The hardware pickup from HW-102 worked good You will have to test on your own.
          
Ver  1.2  March 2012, Added  two level Backlight LCD dimmer.         

   
  Creative Commons Attribution-Noncommercial-Share Alike 3.0 United States License
          http://creativecommons.org/licenses/by-nc-sa/3.0/us/

 
 
 Clock base on Tronixstuff.com 
 
   "Example 7.4
    Digital LCD clock
    tronixstuff.com/tutorials
    based on code by Maurice Ribble
    17-4-2008 - http://www.glacialwanderer.com/hobbyrobotics
    "

CW code based on:

   Simple Arduino Morse Beacon
   Written by Mark VandeWettering K6HX
   Email: k...@arrl.net
   
FOUR THINGS YOU MIGHT WANT TO CHANGE LOOK FOR THE  *******CHANGE LINES ***** FOR MORE INFO
 

*/
// ******************************************** Change lines ****************************  
//                             Change to Your Callsign UPPER CASE only !!!
char* callsign = ("DE N9APK"); 
//
//

#include <Wire.h>
#define DS1307_I2C_ADDRESS 0x68
#include <LiquidCrystal.h> // we need this library for the LCD commands
LiquidCrystal lcd(12, 11, 5, 4, 3, 2);

#include <math.h>                      ///  swr stuff
float SWR = 0;                   // Software works SB-630 pickup unit need work    
float Vratio = 0;                // Not enable  at this time 
float VoltFWD = 0;
float VoltREF = 0;

int photocellPin = 2;       //backlight control
int photocellReading;     
int Backlight = 10;         //Backlight Pin


#define CWpin 6      //output to CW spearker
#define swrpin 7     //input to switch to other mode    Guess which one... not supported YET 
#define startnow 8   //Input CountDown Tmer Start
#define idlight 9    //OutPut ID LED's 


unsigned int CdLoop=0;               // loop variable for Count Down TIMER
unsigned int countdownmins=9;       //Load for 10 min minutes ID Timer
unsigned int countdownseconds=59;   //Load for 10 min Seconds  ID Timer
 
#define N_MORSE  (sizeof(morsetab)/sizeof(morsetab[0]))
#define SPEED  (30)
#define DOTLEN  (1200/SPEED)
#define DASHLEN  (3*(1200/SPEED))
struct t_mtab { char c, pat; } ;
struct t_mtab morsetab[] = {
  	{'.', 106},
	{',', 115},
	{'?', 76},
	{'/', 41},
	{'A', 6},
	{'B', 17},
	{'C', 21},
	{'D', 9},
	{'E', 2},
	{'F', 20},
	{'G', 11},
	{'H', 16},
	{'I', 4},
	{'J', 30},
	{'K', 13},
	{'L', 18},
	{'M', 7},
	{'N', 5},
	{'O', 15},
	{'P', 22},
	{'Q', 27},
	{'R', 10},
	{'S', 8},
	{'T', 3},
	{'U', 12},
	{'V', 24},
	{'W', 14},
	{'X', 25},
	{'Y', 29},
	{'Z', 19},
	{'1', 62},
	{'2', 60},
	{'3', 56},
	{'4', 48},
	{'5', 32},
	{'6', 33},
	{'7', 35},
	{'8', 39},
	{'9', 47},
	{'0', 63}
} ;
void dash()
{
  analogWrite(CWpin, 128) ;
  delay(DASHLEN);
  analogWrite(CWpin, 0) ;
  delay(DOTLEN) ;
}

void dit()
{
  analogWrite(CWpin, 128) ;
  delay(DOTLEN);
  analogWrite(CWpin, 0) ;
  delay(DOTLEN);
}

void send(char c)
{
  int i ;
  if (c == ' ') {
    //Serial.print(c) ;
    lcd.print(c);
    delay(7*DOTLEN) ;
    return ;
}
  for (i=0; i<N_MORSE; i++) {
    if (morsetab[i].c == c) {
      unsigned char p = morsetab[i].pat ;
     // Serial.print(morsetab[i].c) ;
     lcd.print(morsetab[i].c) ;

      while (p != 1) {
          if (p & 1)
            dash() ;
          else
            dit() ;
          p = p / 2 ;
      }
      delay(2*DOTLEN) ;
      return ;
    }
}
  /* if we drop off the end, then we send a space */
  //Serial.print("?") ;
  lcd.print("?");
}

 void sendmsg(char *str)
//void sendmsg(String *str)
{
  while (*str)
    send(*str++) ;
  //Serial.println("");
  lcd.print("");
}


// Convert normal decimal numbers to binary coded decimal
byte decToBcd(byte val)
{
  return ( (val/10*16) + (val%10) );
}
// Convert binary coded decimal to normal decimal numbers
byte bcdToDec(byte val)
{
  return ( (val/16*10) + (val%16) );
}
// 1) Sets the date and time on the ds1307
// 2) Starts the clock
// 3) Sets hour mode to 24 hour clock
// Assumes you're passing in valid numbers
void setDateDs1307(byte second,
byte minute,
byte hour,
byte dayOfWeek,
byte dayOfMonth,
byte month,
byte year) {

Wire.beginTransmission(DS1307_I2C_ADDRESS);
Wire.send(0);
  Wire.send(decToBcd(second));
  Wire.send(decToBcd(minute));
  Wire.send(decToBcd(hour));
  Wire.send(decToBcd(dayOfWeek));
  Wire.send(decToBcd(dayOfMonth));
  Wire.send(decToBcd(month));
  Wire.send(decToBcd(year));
  Wire.send(0x10); // sends 0x10 (hex) 00010000 (binary) to control register - turns on square wave
  Wire.endTransmission();
}
// Gets the date and time from the ds1307
void getDateDs1307(byte *second,
byte *minute,
byte *hour,
byte *dayOfWeek,
byte *dayOfMonth,
byte *month,
byte *year)
{
  // Reset the register pointer
  Wire.beginTransmission(DS1307_I2C_ADDRESS);
  Wire.send(0);
  Wire.endTransmission();
  Wire.requestFrom(DS1307_I2C_ADDRESS, 7);
  // A few of these need masks because certain bits are control bits
  *second     = bcdToDec(Wire.receive() & 0x7f);
  *minute     = bcdToDec(Wire.receive()); // 0 to bit 7 starts the clock
  *hour       = bcdToDec(Wire.receive() & 0x3f);  // Need to change this if 12 hour am/pm
  *dayOfWeek  = bcdToDec(Wire.receive());
  *dayOfMonth = bcdToDec(Wire.receive());
  *month      = bcdToDec(Wire.receive());
  *year       = bcdToDec(Wire.receive());
}

void countdown()
{ 
  lcd.setCursor(0,1);
  lcd.print("Station ID  ");
  lcd.print(countdownmins);
  lcd.print(":");  
  lcd.print(countdownseconds);
        
  if (countdownseconds == 0){
      countdownmins = --countdownmins;             
      countdownseconds = 59;               
      }       
  else{
       countdownseconds = --countdownseconds; 
       }


 if ((countdownmins == 0) && (countdownseconds == 0)){
       
  digitalWrite( idlight, HIGH );  ///  turn on the ID LED's 
  lcd.clear();
  lcd.setCursor(0,0);
  lcd.print(" ID STATION NOW!");
  lcd.setCursor(0,1);
  sendmsg(callsign);
  delay(500);  // Delay for Light and finish of the CW
  digitalWrite( idlight, LOW);
  countdownmins=9;       //reload 10 min timer after a run
  countdownseconds=59;  // ""
  CdLoop = 0;               // Timer loop loop reset to stop 
 
  }

}


void daydate()
{ // Day and Date display      
  byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
  getDateDs1307(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month, &year);
  
  lcd.setCursor(0,1);  
  lcd.print(" ");
  switch(dayOfWeek){
  case 1:
    lcd.print("Sun");
    break;
  case 2:
    lcd.print("Mon");
    break;
  case 3:
    lcd.print("Tue");
    break;
  case 4:
    lcd.print("Wed");
   break;
  case 5:
    lcd.print("Thu");
    break;
  case 6:
    lcd.print("Fri");
    break;
  case 7:
    lcd.print("Sat");
    break; }
  lcd.print("  ");
  lcd.print(month, DEC);  
  lcd.print("/");
  lcd.print(dayOfMonth, DEC);
  lcd.print("/20");
  lcd.print(year, DEC);
}  

void displaySWR()
{lcd.clear();
  lcd.setCursor(0,0);
  lcd.print("SWR ~ ");
  while (digitalRead(swrpin) == LOW ){  
    VoltFWD = analogRead(0);        // Read FWD sensor voltage
    VoltREF = analogRead(1);        // Read REFL sensor voltage
    VoltFWD = map(VoltFWD, 0,1023,0,5000);
    VoltREF = map(VoltREF, 0,1023,0,5000);
            Vratio = VoltREF / VoltFWD;
    SWR = ((1 + Vratio)/ (1 - Vratio));
    lcd.setCursor(7,0);
    lcd.print(SWR);
    delay(100);

 } 
  
}


void setup()
{   // Manual set up clock to right time
  byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
  Wire.begin();
  pinMode(CWpin, OUTPUT);
  Serial.begin(9600);
  //   NOTE ************************************ CHANGE LINES *********************
  //     Change these values to what you want to set your clock to The first time. 
  //    
  second = 10;
  minute = 8;
  hour = 22;
  dayOfWeek = 2;
  dayOfMonth = 14;
  month = 11;
  year = 11;
// ******************************************** Change lines ****************************
//  // You only want to set your clock once and then put the // back in front of the line
//   
//  setDateDs1307(second, minute, hour, dayOfWeek, dayOfMonth, month, year);
//
  pinMode(photocellPin, OUTPUT);
  pinMode(photocellPin, HIGH);
  pinMode(swrpin, HIGH);
  pinMode( idlight, OUTPUT); 
  digitalWrite( idlight, HIGH );
  lcd.begin(2, 16);                  // tells Arduino the LCD dimensions
  lcd.setCursor(0,0);
  lcd.print("SB630-RTC-CW----");         // print text and move cursor to start of next line
  lcd.setCursor(0,1);
  lcd.print("   ");
  sendmsg("DE N9APK");
  delay(5000);                          // 
  lcd.clear();                             // clear LCD screen 
  digitalWrite( idlight, LOW ); 

}

void loop() {
  
  //if(digitalRead(swrpin) == LOW){   //   ////////    SWR Display break out of main Clock loop    /////////  
  //    displaySWR(); 
 //   }
  
     photocellReading = analogRead(photocellPin);  // READ PHOTO CELL SET BACK LIGHT BRIGHTNESS 
 //  Serial.print(photocellReading); // Display the real numbers to set Top and Lower levels of Brightness for you room
  if (photocellReading >= 50 ){       //SET BACKLIGHT TO BRIGHT
     analogWrite(Backlight, 500);
     }
  else
   if(photocellReading <=50 ){       // SET BACKLIGHT TO LOW 
      analogWrite(Backlight, 20);
   }
  
  byte second, minute, hour, dayOfWeek, dayOfMonth, month, year;
  getDateDs1307(&second, &minute, &hour, &dayOfWeek, &dayOfMonth, &month, &year);
  lcd.clear(); // clear LCD screen
  lcd.setCursor(0,0);
  // *********************************Change if don't want to display Zulu ******************************
  lcd.print("Zulu ");
  //lcd.print("     "); // If you don't wnat to Display Zulu put // if front of the line above and remove the two at the begining of this line 
  lcd.print(hour, DEC);
  lcd.print(":");
  if (minute<10)
  {
    lcd.print("0");
  }
  lcd.print(minute, DEC);
  lcd.print(":");
  if (second<10)
  {
    lcd.print("0");
  }
  lcd.print(second, DEC);  
  
  if(CdLoop==0){  // if not in count down loop display the date and day 
     daydate();
     }
    
 if(digitalRead(startnow)==HIGH){
    // button/ IR/ Rf detection set pin 8 to HI
    // if so Set CdLoop=1 to run countdown loop and shut off the date/day    
    CdLoop=1;   //  set for Countdown timer RUN  
    }
  
 if( CdLoop == 1){    // Run Count down loop till Loop=0
    countdown();
    }
 

  delay(1000);
  
}
